package labirinto.ui;

import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;

import javax.swing.BorderFactory;
import javax.swing.JPanel;

import labirinto.Player;
import labirinto.utils.Rect;

/**
 * La vista principale
 * @author koelio
 *@param grid rettangoli che formano la grid 
 */
public class LabPanel extends JPanel implements Observer {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Player player;
	
	public LabPanel(Player player) {
		super();
		this.player = player;
		player.addObserver(this);
		setBorder(BorderFactory.createEtchedBorder());
		
//		
//		JLabel vittoria = new JLabel("Treasure");
//		vittoria.setLocation(400, 400);
//		add(vittoria);
		
	}
	
	protected void paintComponent(Graphics g) {
		super.paintComponent(g); 
		int ray = 15;
		g.drawOval(player.getPos()[0]*120 + ray, player.getPos()[1]*120 + ray, 2 * ray, 2 * ray);
		
		for (int i = 0; i < 3; i++) {
			for (int j = 0; j < 3; j++) {
				(new Rect(15+i*90,15+j*90,90,90)).draw(g);
			}
		}
		g.drawString("Treasure", 212, 265);
		
	}
	
	
	@Override
	public void update(Observable arg0, Object arg1) {
		repaint();
		
		//System.out.println(player.getPos()[0]+" "+player.getPos()[1]); //test
		
	}

}
